#include "../include/typedefs.h"

// Example code from MISRA C:2012 begin
static int32_t count;     /* "count" has internal linkage           */

static void foo ( void )  /* "foo" has internal linkage             */
{
  int16_t count;          /* Non-compliant - "count" has no linkage
                           * but clashes with an identifier with
                           * internal linkage                       */
  int16_t index;          /* "index" has no linkage                 */
}

void bar1 ( void )
{
  static int16_t count;   /* Non-compliant - "count" has no linkage
                           * but clashes with an identifier with
                           * internal linkage                       */
  int16_t index;          /* Compliant - "index" is not unique but
                           * has no linkage                         */
  foo ( );
}
// Example code from MISRA C:2012 end
